c----------------------------------------------------------------------
c       neq  =  number of equations of motion
c       h    =  stepsize
c       t    =  value of independent variable on entry;
c               set to t+h on exit
c       s    =  approximate solution at t on entry;
c               set to approximate solution at t+h on exit
c       rhs  =  subroutine which computes the rhs of the equations of
c               motion; has the form
c
c               subroutine rhs(t, s, dsdt)
c 
c               and is declared external in the calling program
c       dsdt =  workspace array of at least neq elements to store results
c               of rhs
c----------------------------------------------------------------------

      subroutine euler(neq, h, t, s, rhs, dsdt)
      implicit none
      integer neq, i
      real h, t, s(1:neq), dsdt(1:neq)
      external rhs

      call rhs(t, s, dsdt)
      do i = 1, neq
         s(i) = s(i) + h*dsdt(i)
      end do
      t = t + h
      end subroutine euler
