      program cellular
      implicit none

c     Title: Simple Cellular Automata
c     Author: Christian Buth
c     Date: 20/10/1998


c
c     Constants
c

      integer maxCells, nGenerations
      parameter (maxCells=40)        ! Maximum amount of cells to be used
      parameter (nGenerations=40)    ! Number of generations to be generated


c
c     Main
c

c     Variables
      integer i, gen, ncells, choice, rule
      integer a(0:maxCells-1)        ! The system
      integer f(0:7)                 ! The result array
      character answer

c     Initialisation
      write (*,*) 'Simple Cellular Automata by Christian Buth'
 1    write (*,*)
      
c     Ask for number of cells
      write (*,*) 'Choose input data:'
      write (*,*) '  1: 40 cells, rule 105, asterisk on 21'
      write (*,*) '  2: regular pattern >* * * * <'
      write (*,*) '  3: single cell 21 is alive. Rule is asked.'
      write (*,*) '  4: custom values'
      write (*,*)
      read (*,*) choice
      write (*,*)
      if (choice.lt.1.OR.choice.gt.4) then
         write (*,*) 'Illegal range'
         go to 1
      end if

      select case (choice)
         case (1)
            ncells = maxCells
            rule = 105
            call ruleTOarray(rule,f)
            do i=0, maxCells-1
               a(i) = 0
            end do
            a(maxCells / 2) = 1
         case (2)
            ncells = maxCells
            write (*,*) 'Enter rule to be applied: '
            read (*,*) rule
            call ruleTOarray(rule,f)
            do i=0, maxCells-1
               a(i) = mod(i,2)
            end do
         case (3)
            ncells = maxCells
            write (*,*) 'Enter rule to be applied: '
            read (*,*) rule
            call ruleTOarray(rule,f)
            do i=0, maxCells-1
               a(i) = 0
            end do
            a(20) = 1        
         case default
            call getConfig(a,f,ncells)
      end select
            
c     Produce and print generations
      write (*,*)
      do
         do gen=0, nGenerations-1
            call showGen(a,ncells)
            call nextGen(f,a,ncells)
         end do
         write (*,*) 'Another',nGenerations,' generations? (Y/N)'
 2       read (*,*) answer
         if (answer.eq.'n'.OR.answer.eq.'N') then
            stop
         else if (answer.ne.'y'.AND.answer.ne.'Y') then
            go to 2
         end if
      end do
      
      end program cellular


c
c     Read configuration
c

      subroutine getConfig(a,f,ncells)
      implicit none
      integer rule, ncells, i, maxCells
      parameter (maxCells=40)        ! Maximum amount of cells to be used
      integer a(0:maxCells-1)        ! The system
      integer f(0:7)                 ! The result array
      character s(0:maxCells-1)      ! userinput of configuration
      
c     Ask for number of cells
      write (*,*) 'Enter number of cells to use (maximum of 40):'
      read (*,*) ncells
      if (ncells.lt.0.AND.ncells.gt.40) then
         write (*,*) 'Range of cells from 1 to 40'
         stop
      end if      
      
c     Prompt for an initial configuration 
      write (*,*) 'Configuration (Use " " or "*" for each cell):'
      read(*,'(100a)') (s(i), i=0,ncells-1)
      do i = 0, ncells-1
         if (s(i).eq.'*') then
            a(i) = 1
         else
            a(i) = 0
         end if
      end do
      
c     Read in and convert rule
      write (*,*) 'Enter rule to be applied:'
      read (*,*) rule
      call ruleTOarray(rule,f)
      end subroutine getConfig
      
      
c
c     Convert rule to array
c

      subroutine ruleTOarray(rule,f)
      implicit none
      integer rule, f(0:7), i
      
      if (rule.gt.255.OR.rule.lt.0) then
         write (*,*) 'Rules must be in the range 0 - 255!'
         stop
      end if
      do i = 0, 7
         f(7-i) = mod(rule,2)
         rule = rule / 2
      end do
      end subroutine ruleTOarray
      

c      
c     Print generation
c

      subroutine showGen(a,ncells)
      implicit none
      integer i, ncells, maxCells
      parameter (maxCells=40)        ! Maximum amount of cells to be used
      integer a(0:maxCells-1)
      character s(0:maxCells-1)
      
      do i=0, ncells-1
         if (a(i).gt.0) then
            s(i) = '*'
         else
            s(i) = ' '
         end if
      end do
      write (*,*) (s(i), i=0, ncells-1)
      end subroutine showGen


c
c     Next generation
c

      subroutine nextGen(f,a,ncells)
      implicit none
      integer maxCells, f(0:7), i, ncells
      parameter (maxCells=40)        ! Maximum amount of cells to be used
      integer a(0:maxCells-1), b(0:maxCells-1)

      do i=0, ncells-1
c     +ncells in mod statement is used to convert -1 to ncells-1
         b(i) = 4*a(mod(i-1+ncells,ncells))
         b(i) = b(i) + 2*a(mod(i,ncells))
         b(i) = b(i) + a(mod(i+1,ncells))
         b(i) = f(b(i))
      end do

      do i = 0, ncells-1 
         a(i) = b(i)
      end do
      end subroutine nextGen
