      program Euler_Algorithm
      implicit none

c     Title: Euler Algorithm
c     Author: Christian Buth
c     Date: 03/11/1998


c
c     Main
c

c     Variables
      real k_by_m, g, v_t, v_t_h, v_of_1, h
      integer N, i
      k_by_m = 3.0            ! k/m=3 (sec^(-1)) and g=9.81 (metres/sec^2)
      g = 9.81
      v_t = 0.0               ! start at rest
      
c     Initialisation
      write (*,*) 'Solving a simple differential Equation'
      write (*,*) 'by Christian Buth'
      write (*,*)
      write (*,*) 'Input number of steps:'
      read (*,*) N
      write (*,*)
      h = 1.0 / N

c     Calculate result with analytic solution
      v_of_1 = 1.0 / k_by_m * g * (1.0 - exp(-k_by_m))
      write (*,*) 'Analytic result: v( 1 ) = ', v_of_1        
        
c     Calculate result with Euler's algorithm
      do i=1,N-1
         v_t_h = v_t + h * (g - k_by_m * v_t)
         v_t = v_t_h
      end do
      write (*,*) 'Numeric result: v(', i, '*h ) = ', v_t_h
      
      end program Euler_Algorithm


