      program Simpson
      implicit none

c     Title: Simpsons Rule
c     Author: Christian Buth
c     Date: 10/11/1998


c
c     Main
c

c     Variables
      real fx, simpsonInt
      external fx
      integer N
      
c     Initialisation
      write (*,*) 'Numerical integration using Simpson''s rule'
      write (*,*) 'by Christian Buth'
      write (*,*)
      write (*,*) 'Input number of steps:'
      read (*,*) N
      write (*,*)
        
      write (*,*) 'int(sin(x)^3,x=0..10): ', simpsonInt(N,fx)
      
      end program Simpson

      
c
c     Simpson's rule
c

      real function simpsonInt(N,f)
      implicit none
      real a, intF, h, f
      integer N, i
      external f
      h = 10.0 / N
      intF = 0
      a = 0

c     Calculate result with Euler's algorithm
      do i=1, N
         intF = intF + h/6.0*(f(a)+4.0*f(a+h/2.0)+f(a+h))
         a = a + h
      end do      
      simpsonInt = intF
      
      end function simpsonInt

      
c
c     The integrand
c

      real function fx(x)
      implicit none
      real x
      fx = sin(x)**3
      
      end function fx








