      program Celestrial_Mechanics
      implicit none

c     Title: Celestrial Mechanics
c     Author: Christian Buth
c     Date: 17/11/1998


c
c     Main
c

c     Variables
      real s(1:4), dsdt(1:4), h, t, pi
      integer nsteps, i, fn
      parameter (fn=10)
      external rhs
      pi = acos(-1.0)
      t = 0.0

c     Initialisation
      write (*,*) 'Celestrial Mechanics Simulation'
      write (*,*) 'by Christian Buth'
      write (*,*)
      write (*,*) 'Input number of steps:'
      read (*,*) nsteps
      h = 2.0 * pi / nsteps

c     Calculate trajectory
      open(fn, file='Exercise4.3.dat')
      do i=1, nsteps
         call euler(4,h,t,s,rhs,dsdt)
         write (*,*) 'Time',t,'  x = ',s(1),'  y = ',s(2)
         write (fn,*) s(1),s(2)
      end do
      close(fn)

      end program Celestrial_Mechanics


c
c     The rhs of the system of differential equations      
c

      subroutine rhs(t, s, dsdt)
      implicit none
      real t, s(1:4), dsdt(1:4), rad

c     Initial values
      if (t.eq.0.0) then
         s(1) = 1
         s(2) = 0
         s(3) = 0
         s(4) = 1
      end if
      
c     Compute right hand side
      rad = sqrt(s(1)**2 + s(2)**2)
      dsdt(1) = s(3)
      dsdt(2) = s(4)
      dsdt(3) = -1.0 * s(1) / (rad**3)
      dsdt(4) = -1.0 * s(2) / (rad**3)
      end subroutine rhs
