      program Startrek_RK4
      implicit none

c     Title: Startrek
c     Author: Christian Buth
c     Date: 19/11/1998


c
c     Main
c

c     Variables
      integer nsteps
      real t_stp

c     Initialisation
      write (*,*) 'Startrek Simulation (Rk4)'
      write (*,*) 'by Christian Buth'
      write (*,*)
      write (*,*) 'Enter stop time:'
      read (*,*) t_stp

c     Calculate trajectories with certain numbers of steps
      do nsteps = 600, 6000, 600
         call trajectory(nsteps,t_stp)
      end do 

      end program Startrek_RK4


c
c     Calculate trajectory and output last position of space vehicle
c

      subroutine trajectory(nsteps,t)
      implicit none
      real s(1:4), w(1:3*4), h, t
      integer nsteps, i, fn
      parameter (fn=10)
      external rhs
      t = 0
      h = t / nsteps

c     Write data to file for 600, 1800, 6000 steps
      if (nsteps.eq.600) then
         open(fn, file='Exercise4.7_600.dat')
      else if (nsteps.eq.1800) then
         open(fn, file='Exercise4.7_1800.dat')
      else if (nsteps.eq.6000) then
         open(fn, file='Exercise4.7_6000.dat')
      end if

c     Calculate trajectory
      do i=1, nsteps
         call rkstp(4,h,t,s,rhs,w)
         if (nsteps.eq.600.OR.nsteps.eq.1800.OR.nsteps.eq.6000) then
            write (fn,*) s(1),s(2)
         end if
      end do

c     Close data file
      if (nsteps.eq.600.OR.nsteps.eq.1800.OR.nsteps.eq.6000) then
         close(fn)
      end if
      write (*,*) 'nsteps',nsteps,'  Time',t,'  x = ',s(1),'  y = ',s(2)

      end subroutine trajectory


c
c     The rhs of the system of differential equations      
c

      subroutine rhs(t, s, dsdt)
      implicit none
      real t, s(1:4), dsdt(1:4), rad, v0, angle, pi, m
      integer i

c     Initial values
      m = 100.0
      if (t.eq.0.0) then
         v0 = 4
         pi = acos(-1.0)
         angle = 17.5 / 180 * pi
         s(1) = 0
         s(2) = 0
         s(3) = v0 * cos(angle)
         s(4) = v0 * sin(angle)
      end if
      
c     Compute right hand side
      dsdt(1) = s(3)
      dsdt(2) = s(4)
      dsdt(3) = 0
      dsdt(4) = 0

      do i = 3,9,2
            rad = sqrt((s(1) - i)**2 + (s(2) - i)**2)
          dsdt(3) = dsdt(3) - m * (s(1) - i) / (rad**3)
          dsdt(4) = dsdt(4) - m * (s(2) - i) / (rad**3)
      end do

      end subroutine rhs
