c------------------------------------------------------------
c
c Here is the code for puni
c Modified by Christian Buth (renamed COMMON block SET1 to
c PSET1 to avoid conflicts with uni)
c
c------------------------------------------------------------

      REAL FUNCTION PUNI(ITHREAD)
      IMPLICIT NONE
C ***   FIRST CALL RSTART(I,J,K,L)
C ***   WITH I,J,K,L INTEGERS
C ***   FROM 1...168 NOT ALL 1
      INTEGER ITHREAD,MAXTHREAD
      PARAMETER (MAXTHREAD=8)
      REAL U(97,0:MAXTHREAD-1)
      INTEGER IU(0:MAXTHREAD-1),JU(0:MAXTHREAD-1)
      REAL C(0:MAXTHREAD-1), CM, CD
      COMMON /PSET1/ U,IU,JU,C
      SAVE /PSET1/
C      DATA I,J/97,33/

      IF (ITHREAD .LT. 0 .OR. ITHREAD .GE. MAXTHREAD) THEN
        WRITE(*,*) 'PUNI: Error,illegal value ITHREAD = ', ITHREAD
        STOP
      END IF

      CD = (7654321./16777216.) 
      CM = (16777213./16777216.)
      PUNI=U(IU(ITHREAD),ITHREAD)-U(JU(ITHREAD),ITHREAD)
      IF(PUNI.LT.0.) PUNI=PUNI+1.
      U(IU(ITHREAD),ITHREAD)=PUNI
      IU(ITHREAD)=IU(ITHREAD)-1
      IF(IU(ITHREAD).EQ.0) IU(ITHREAD)=97
      JU(ITHREAD)=JU(ITHREAD)-1
      IF(JU(ITHREAD).EQ.0) JU(ITHREAD)=97
      C(ITHREAD)=C(ITHREAD)-CD
      IF(C(ITHREAD).LT.0.) C(ITHREAD)=C(ITHREAD)+CM
      PUNI=PUNI-C(ITHREAD)
      IF(PUNI.LT.0.) PUNI=PUNI+1
      RETURN
      END

C
C  The algorithm from James RMARIN
C  to generate the 4 seeds from and
C  INTEGER in the range 0 <= seed <= 900 000 000
C
        SUBROUTINE PRINIT( IJKL , ITHREAD)
      IMPLICIT NONE
      INTEGER ITHREAD
        INTEGER IJKL, IJ, KL, I, J, K, L

        IJ=IJKL/30082
        KL=IJKL - 30082*IJ
        I = MOD(IJ/177,177)+2
        J=MOD(IJ,177)+2
        K=MOD(KL/169,178)+1
        L=MOD(KL,169)

        CALL PRSTART(I,J,K,L,ITHREAD)

        RETURN
        END


      SUBROUTINE PRSTART(IP,JP,KP,LP,ITHREAD)
      IMPLICIT NONE
      INTEGER ITHREAD,MAXTHREAD
      PARAMETER (MAXTHREAD=8)
      REAL U(97,0:MAXTHREAD-1)
      INTEGER I,J,K,L
      INTEGER IP, JP, KP, LP
      INTEGER IU(0:MAXTHREAD-1),JU(0:MAXTHREAD-1)
      REAL C(0:MAXTHREAD-1), S, T
      COMMON /PSET1/ U,IU,JU,C
      SAVE /PSET1/
      INTEGER II, JJ, M

      I = IP
      J = JP
      K = KP
      L = LP
      DO 2 II=1,97
      S=0.
      T=.5
      DO 3 JJ=1,24
        M=MOD(MOD(I*J,179)*K,179)
        I=J
        J=K
        K=M
        L=MOD(53*L+1,169)
        IF(MOD(L*M,64).GE.32) S=S+T
        T=.5*T
3     CONTINUE
      U(II,ITHREAD)=S
2     CONTINUE
      C(ITHREAD)=362436./16777216.
C      CD=7654321./16777216.
C      CM=16777213./16777216.
      IU(ITHREAD)=97
      JU(ITHREAD)=33
      RETURN
      END
