/*
** bungsblatt 11 Aufgaben 2 und 3 --- Fixpunktiteration
** Coded by Christian Buth
** 18.07.2000
**
** Version 1.00: 18.07.2000 (Fixpunktiteration in ein und zwei Dimensionen
**      implementiert.  Aufgaben 2 und 3 von bungsblatt 11 gelst.)
*/


/*
** Includes
*/

#include <math>
#include <stdlib>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <utility>


/*
** Konstanten
*/

const double epsilon = 1E-8,
             upperbound = 1E8;


/*
** Typedefs
*/

typedef std::pair<double,double> Vector;


/*
** Inline
*/

inline double sqr(double x)
  {
    return(x*x);
  }


/*
** Prototypen
*/

double Fixpunktiteration_1D(double,double (*)(double));
Vector Fixpunktiteration_2D(Vector,Vector (*)(Vector));
double f1(double);
double f2(double);
double f3(double);
double f4(double);
Vector g(Vector);


/*
** main
*/

int main()
  {
    /* Begrungstext */
    cout << "Fixpunktiteration von Christian Buth\n"
            "(c) 2000 Christian Buth\n\n";

    /* Fixpunktiteration fr bungsblatt 11: Aufgabe 2 */
    cout << "bungsblatt 11: Aufgabe 2\n"
            "Fixpunktiteration von f1:\n";
    Fixpunktiteration_1D(0.2,f1);
    Fixpunktiteration_1D(0.4,f1);
    Fixpunktiteration_1D(0.7,f1);
    Fixpunktiteration_1D(1  ,f1);
    cout << "\nFixpunktiteration von f2:\n";
    Fixpunktiteration_1D(0.2,f2);
    Fixpunktiteration_1D(0.4,f2);
    Fixpunktiteration_1D(0.7,f2);
    Fixpunktiteration_1D(1  ,f2);
    cout << "\nFixpunktiteration von f3:\n";
    Fixpunktiteration_1D(0.2,f3);
    Fixpunktiteration_1D(0.4,f3);
    Fixpunktiteration_1D(0.7,f3);
    Fixpunktiteration_1D(1  ,f3);
    cout << "\nFixpunktiteration von f4:\n";
    Fixpunktiteration_1D(0.2,f4);
    Fixpunktiteration_1D(0.4,f4);
    Fixpunktiteration_1D(0.7,f4);
    Fixpunktiteration_1D(1  ,f4);

    /* Fixpunktiteration fr bungsblatt 11: Aufgabe 3 */
    cout << "\nbungsblatt 11: Aufgabe 3\n"
            "Fixpunktiteration von g:\n";
    Fixpunktiteration_2D(Vector(0.2,1),g);
    return(EXIT_SUCCESS);
  }


/*
** Fixpunktiterationsverfahren
*/

double Fixpunktiteration_1D(double x0,double (*f)(double))
  {
    register int n = 0;
    double x1 = x0;

    do
      {
        n++;
        x0 = x1;
        x1 = (*f)(x0);
        cout << setprecision(8) << setw(10) << setiosflags(ios::left) << x0;
        if (! (n % 5))
            cout << endl;
        else
            cout << '\t';
      }
    while (n < 30 && fabs(x1 - x0) >= epsilon && fabs(x1) < upperbound);

    if (fabs(x1) >= upperbound)
        cout << "divergent";
    else
        cout << x1;
    cout << "\n\n";
    return(x1);
  }


Vector Fixpunktiteration_2D(Vector x0,Vector (*f)(Vector))
  {
    register int n = 0;
    Vector x1 = x0;

    do
      {
        n++;
        x0 = x1;
        x1 = (*f)(x0);
        cout << setprecision(8) << setiosflags(ios::left) << '(' << setw(10)
             << x0.first << ',' << setw(10) << x0.second << ')';
        if (! (n % 3))
            cout << endl;
        else
            cout << '\t';
      }
    while (n < 30 && (fabs(x1.first - x0.first) >= epsilon
                  || fabs(x1.second - x0.second) >= epsilon)
                  && fabs(x1.first) < upperbound
                  && fabs(x1.second) < upperbound);

    if (fabs(x1.first) >= upperbound || fabs(x1.second) >= upperbound)
        cout << "divergent";
    else
        cout << setprecision(8) << '(' << setw(10) << x1.first << ','
             << setw(10) << x1.second << ')';
    cout << "\n\n";
    return(x1);
  }


/*
** Funktionen fr die Fixpunktiteration
*/

double f1(double x)
  {
    if (x > 0)
        return(-log(x));
    return(upperbound);
  }

double f2(double x)
  {
    return(exp(-x));
  }

double f3(double x)
  {
    return(0.5 * (x + exp(-x)));
  }

double f4(double x)
  {
    return((1 - log(x)) / (1 + 1 / x));
  }

Vector g(Vector x1)
  {
    return(Vector(1.0 / (5 + sqr(x1.first) + sqr(x1.second)),
           pow(x1.first + x1.second,0.25)));
  }
