* Realisierung einer Laufschrift
* Coded by Chris
* 12.7.1991


	* includes

		incdir "IASM:"
		include "exec/exec_lib.i"
		include "exec/nodes.i"
		include "exec/interrupts.i"
		include "hardware/intbits.i"
		include "hardware/dmabits.i"
		incdir "ASOURCE:Demos/source/"
		include "register.i"
		include "coppermac.i"

		SECTION	main,CODE

		
	* equs

gb_copinit equ 38


	*****************************************
	* Als erstes Playfield ffnen		*
	*****************************************

	* Graphics ffnen
	
start:		moveq.l	#0,d0				; version egal
		lea.l	gfxname(pc),a1			; ^gfxname
		CALLEXEC OpenLibrary
		tst.l	d0				; fehler ?
		beq	fini
		lea.l	_GfxBase(pc),a0			; ^GfxBase laden
		move.l	d0,(a0)				; retten
		
		
	* Multitasking aus und Pointer in Strukturen schreiben
	
		lea.l	scroll(pc),a0			; ^Routine nach a0
		lea.l	intstruct(pc),a1		; ^Interrupt nach a1
		move.l	a0,IS_CODE(a1)			; ^eintragen
		lea.l	message(pc),a0			; ^text nach a0
		lea.l	textptr(pc),a1			; ^^text nach a1
		move.l	a0,(a1)				; ^eintrzagen
		CALLEXEC Forbid				; Interrupts aus


	* DMACON aus
		
		lea.l	CUSTOM,a0			; basisadresse customchips
		move.w	#DMAF_SPRITE!DMAF_RASTER!DMAF_COPPER,DMACON(a0)	; Bitplane-DMA an
		
		
	* displaywindow gre setzen
		
		move.w	#$2981,DIWSTRT(a0)		; Displaygre initialisieren
		move.w	#$29c1,DIWSTOP(a0)
		
		
	* datafetch spezifizieren
	
		move.w	#$38,DDFSTRT(a0)		; DataFetch
		move.w	#$d0,DDFSTOP(a0)
	
	
	* BPLCONS init
		
		move.w	#%0100000000000000,BPLCON0(a0)	; BlpConx intitialisieren
		move.w	#0,BPLCON1(a0)			; interesiert uns nicht
		move.w	#0,BPLCON2(a0)
		
		move.w	#4,BPL1MOD(a0)			; Modulo initilisieren
		move.w	#4,BPL2MOD(a0)			; Modulo initilisieren
	
	
	* Pointer fr coplist init fr 4 bitplanes
	
		move.l	#picture,d0			; addresse in copperlist
		move.w	d0,p1l
		swap	d0				; nchstes wort
		move.w	d0,p1h
		
		move.l	#picture+352/8*290,d0		; addresse 2 plane in copperlist
		move.w	d0,p2l
		swap	d0				; nchstes wort
		move.w	d0,p2h
		
		move.l	#picture+2*(352/8*290),d0	; addresse 2 plane in copperlist
		move.w	d0,p3l
		swap	d0				; nchstes wort
		move.w	d0,p3h		

		move.l	#picture+3*(352/8*290),d0	; addresse 2 plane in copperlist
		move.w	d0,p4l
		swap	d0				; nchstes wort
		move.w	d0,p4h		
		
	
	* COPPER an
		
		move.l	#copperlist,COP1LCH(a0)		; CopperListenzeiger setzen
		move.w  #0,COPJMP1(a0)			; CopperListe 2 aktivieren


	* DMACON an und Musikroutine initialisieren

		move.w	#DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER,DMACON(a0)	; Bitplane-DMA an
		bsr	mt_init				; initialisieren
		
		
	* Interrupt installieren
	
		moveq.l	#INTB_VERTB,d0
		lea.l	intstruct(pc),a1		; zeiger auf interrupt struct
		CALLEXEC AddIntServer
		
				
	* auf maustastendruck warten
		
maus:		btst.b	#6,$bfe001
		bne.s	maus
		
		
	* Interrupt entfernen
	
		moveq.l	#INTB_VERTB,d0
		lea.l	intstruct(pc),a1		; zeiger auf interrupt struct
		CALLEXEC RemIntServer		
	
		
	* alte copperliste wieder rein und Musik aus
	
		bsr	mt_end				; Musik ausschalten
		lea.l	CUSTOM,a0			; basisadresse customchips
		move.l	_GfxBase(pc),a1			; holen
		move.l	gb_copinit(a1),COP1LCH(a0)	; neue cop list
		move.w	#0,COPJMP1(a0)			; aktivieren
		
		
	* multitasking erlauben DMAS an
	
		move.w	#DMAF_SETCLR!DMAF_SPRITE,DMACON(a0)	; Sprite-DMA an
		CALLEXEC Permit
		
		
	* Graphics
		
		move.l	_GfxBase(pc),a1			; gfxbase holen
		CALLEXEC CloseLibrary
		
		
	* Ende
	
fini:		rts
		

	*****************************************
	* Interrupt: Scrollen der Zeichen	*
	* ausgabe zeichen			*
	*****************************************
	
scroll:		movem.l	d0-d7/a0-a6,-(sp)		; register retten


	* 1 bit scrollen

scroll2:	bsr	scrollbit 			; ein bit nach rechts scrollen


	* wenn ntig zeichen ausgeben
	
		lea.l	textcount(pc),a0		; ^Zhler laden
		subq.w	#2,(a0)				; eins vermindern
		tst.w	(a0)				; neues zeichen ausgeben
		bhi.s	quit
		move.w	#32,(a0)			; zhler reset
		
getchar:	move.l	textptr(pc),a5			; zeiger auf nchstes zeichen holen
		move.b	(a5)+,d0			; zeichen holen
		lea.l	textptr(pc),a0			; ^textptr laden
		move.l	a5,(a0)				; zeiger wieder speichern
		and.l	#$ff,d0				; auf langwort erweitern
		tst.b	d0				; ende ?
		bhi.s	do_out				; wenn nicht null weiter
		lea.l	message(pc),a1			; ^Message laden
		move.l	a1,(a0)				; pointer restoren
		bra.s	getchar				; noch mal
do_out:		bsr.s	printchar			; zeichen ausgeben
quit:		bsr	mt_music			; Musikroutine einspringen
		movem.l	(sp)+,d0-d7/a0-a6		; register restoren
		bsr	waitblit
		rts	


	* Unterprogramm: Zeichen darstellen
	* d0: zeichen
	
printchar:	sub.b	#' ',d0				; code extrahieren
		ext.l	d0				; auf langwort
		divu	#10,d0				; oberers wort x coor unteres y
		move.w	d0,d1				; y nach d1
		swap	d0				; x holen

		and.l	#$ffff,d0			; auf wort begrenzen
		and.l	#$ffff,d1			; auf wort begrenzen

		lsl.l	#2,d0				; lnge eintes buchstabens
		mulu	#32*40,d1			; mal lnge einter zeile = y address offset
		add.l	#fontdata,d1			; fontdatenaddresse drauf
		add.l	d0,d1				; x position in bytes
		 

	*************************
	* zeichen ausgeben	*
	*************************
	
		move.l	#picture+(210*(352/8))+(320/8),d2; zeiger auf zielbereich
		moveq.l	#3,d7				; 4 planes
		
		lea.l	CUSTOM,a0
writeplane:	bsr	waitblit
		move.w	#320/8-4,BLTAMOD(a0)		; plane fr plane schreiben
		move.w	#352/8-4,BLTDMOD(a0)
		move.l	d1,BLTAPTH(a0)			; in d1 adresse buchstabe quelle setzen			
		move.l	d2,BLTDPTH(a0)			; zeiger auf zielbereich
		move.w	#%0000100111110000,BLTCON0(a0)	; minterm A=D ($f0) use a and d
		move.w	#0,BLTCON1(a0)			; egal
		move.w	#$ffff,BLTAFWM(a0)		; erste maske
		move.w	#$ffff,BLTALWM(a0)		; letzte maske
		move.w	#(32<<6)!2,BLTSIZE(a0)		; dann arbeite
		
	;------ zeiger erhhen
		
		addi.l	#320/8*192,d1			; nchste fontplane
		addi.l	#352/8*290,d2			; nchste bildplane
		
		dbra	d7,writeplane
		rts
		

	**********
	* scroll *
	**********
			
scrollbit:	move.l	#picture+(210*352/8)+(32*352/8)-2,d1; in d1 ist die
							; Adresse der Quelle
		lea.l	CUSTOM,a0
		moveq.l	#3,d7				; 4 planes verschieben

	;------ blitter starten

;moveplane:	bsr.s	waitblit
;		move.w	#0,BLTAMOD(a0)			; keine bytes am anfang skippen
;		move.w	#0,BLTDMOD(a0)			; restliche bytes skippen
;		move.l	d1,BLTAPTH(a0)			; in d1 adresse buchstabe quelle setzen			
;		move.l	d1,BLTDPTH(a0)			; ziel
;		move.w	#%0010100111110000,BLTCON0(a0)	; minterm A=D ($f0) use a and d
;		move.w	#%0000000000000010,BLTCON1(a0)	; decending mode
;		move.w	#$ffffffff,BLTAFWM(a0)		; Masken beschreiben
;		move.w	#(32<<6)!(352/16),BLTSIZE(a0)	; dann arbeite
		
	;------ zeiger erhhen
		
		addi.l	#352/8*290,d1			; nchste plane
		dbra	d7,moveplane
		rts
		
		
	*************************
	* blitwarterutine	*
	*************************
	
waitblit:	move.l	d0,-(sp)
		move.w	#DMAF_SETCLR!DMAF_BLITHOG,DMACON+CUSTOM
.tstblit:	move.w	DMACONR+CUSTOM,d0		; DMAcon holen
		btst	#14,d0				; glelscht blitter fertig
		bne.s	.tstblit
		move.w	#DMAF_BLITHOG,DMACON+CUSTOM
		move.l	(sp)+,d0
		rts


;
;   NoisetrackerV1.0 replayroutine   
; Mahoney & Kaktus - HALLONSOFT 1989 
;
mt_init:lea	musikdata,a0		;Initalisieren
	move.l	a0,a1			; (wieder $41200 relativieren)
	add.l	#$3b8,a1
	moveq	#$7f,d0
	moveq	#0,d1
mt_loop:move.l	d1,d2
	subq.w	#1,d0
mt_lop2:move.b	(a1)+,d1
	cmp.b	d2,d1
	bgt.s	mt_loop
	dbf	d0,mt_lop2
	addq.b	#1,d2

	lea	mt_samplestarts(pc),a1
	asl.l	#8,d2
	asl.l	#2,d2
	add.l	#$43c,d2
	add.l	a0,d2
	move.l	d2,a2
	moveq	#$1e,d0
mt_lop3:clr.l	(a2)
	move.l	a2,(a1)+
	moveq	#0,d1
	move.w	42(a0),d1
	asl.l	#1,d1
	add.l	d1,a2
	add.l	#$1e,a0
	dbf	d0,mt_lop3

	or.b	#$2,$bfe001
	move.b	#$6,mt_speed
	clr.w	$dff0a8
	clr.w	$dff0b8
	clr.w	$dff0c8
	clr.w	$dff0d8
	clr.b	mt_songpos
	clr.b	mt_counter
	clr.w	mt_pattpos
	rts

mt_end:	clr.w	$dff0a8			;Zum stoppen
	clr.w	$dff0b8			; (Soundkanle aus)
	clr.w	$dff0c8
	clr.w	$dff0d8
	move.w	#$f,$dff096
	rts

mt_music:				;In jedem VBlk einspringen
	movem.l	d0-d4/a0-a3/a5-a6,-(a7)
	lea	musikdata,a0		;^Song
	addq.b	#$1,mt_counter
	move.b	mt_counter,D0
	cmp.b	mt_speed,D0
	blt.s	mt_nonew
	clr.b	mt_counter
	bra	mt_getnew

mt_nonew:
	lea	mt_voice1(pc),a6
	lea	$dff0a0,a5
	bsr	mt_checkcom
	lea	mt_voice2(pc),a6
	lea	$dff0b0,a5
	bsr	mt_checkcom
	lea	mt_voice3(pc),a6
	lea	$dff0c0,a5
	bsr	mt_checkcom
	lea	mt_voice4(pc),a6
	lea	$dff0d0,a5
	bsr	mt_checkcom
	bra	mt_endr

mt_arpeggio:
	moveq	#0,d0
	move.b	mt_counter,d0
	divs	#$3,d0
	swap	d0
	cmp.w	#$0,d0
	beq.s	mt_arp2
	cmp.w	#$2,d0
	beq.s	mt_arp1

	moveq	#0,d0
	move.b	$3(a6),d0
	lsr.b	#4,d0
	bra.s	mt_arp3
mt_arp1:moveq	#0,d0
	move.b	$3(a6),d0
	and.b	#$f,d0
	bra.s	mt_arp3
mt_arp2:move.w	$10(a6),d2
	bra.s	mt_arp4
mt_arp3:asl.w	#1,d0
	moveq	#0,d1
	move.w	$10(a6),d1
	lea	mt_periods(pc),a0
	moveq	#$24,d7
mt_arploop:
	move.w	(a0,d0.w),d2
	cmp.w	(a0),d1
	bge.s	mt_arp4
	addq.l	#2,a0
	dbf	d7,mt_arploop
	rts
mt_arp4:move.w	d2,$6(a5)
	rts

mt_getnew:
	lea	musikdata,a0
	move.l	a0,a3
	move.l	a0,a2
	add.l	#$c,a3
	add.l	#$3b8,a2
	add.l	#$43c,a0

	moveq	#0,d0
	move.l	d0,d1
	move.b	mt_songpos,d0
	move.b	(a2,d0.w),d1
	asl.l	#8,d1
	asl.l	#2,d1
	add.w	mt_pattpos,d1
	clr.w	mt_dmacon

	lea	$dff0a0,a5
	lea	mt_voice1(pc),a6
	bsr.s	mt_playvoice
	lea	$dff0b0,a5
	lea	mt_voice2(pc),a6
	bsr.s	mt_playvoice
	lea	$dff0c0,a5
	lea	mt_voice3(pc),a6
	bsr.s	mt_playvoice
	lea	$dff0d0,a5
	lea	mt_voice4(pc),a6
	bsr.s	mt_playvoice
	bra	mt_setdma

mt_playvoice:
	move.l	(a0,d1.l),(a6)
	addq.l	#4,d1
	moveq	#0,d2
	move.b	$2(a6),d2
	and.b	#$f0,d2
	lsr.b	#4,d2
	move.b	(a6),d0
	and.b	#$f0,d0
	or.b	d0,d2
	tst.b	d2
	beq.s	mt_setregs
	moveq	#0,d3
	lea	mt_samplestarts(pc),a1
	move.l	d2,d4
	subq.l	#$1,d2
	asl.l	#2,d2
	mulu	#$1e,d4
	move.l	(a1,d2.l),$4(a6)
	move.w	(a3,d4.l),$8(a6)
	move.w	$2(a3,d4.l),$12(a6)
	move.w	$4(a3,d4.l),d3
	tst.w	d3
	beq.s	mt_noloop
	move.l	$4(a6),d2
	asl.w	#1,d3
	add.l	d3,d2
	move.l	d2,$a(a6)
	move.w	$4(a3,d4.l),d0
	add.w	$6(a3,d4.l),d0
	move.w	d0,8(a6)
	move.w	$6(a3,d4.l),$e(a6)
	move.w	$12(a6),$8(a5)
	bra.s	mt_setregs
mt_noloop:
	move.l	$4(a6),d2
	add.l	d3,d2
	move.l	d2,$a(a6)
	move.w	$6(a3,d4.l),$e(a6)
	move.w	$12(a6),$8(a5)
mt_setregs:
	move.w	(a6),d0
	and.w	#$fff,d0
	beq	mt_checkcom2
	move.b	$2(a6),d0
	and.b	#$F,d0
	cmp.b	#$3,d0
	bne.s	mt_setperiod
	bsr	mt_setmyport
	bra	mt_checkcom2
mt_setperiod:
	move.w	(a6),$10(a6)
	and.w	#$fff,$10(a6)
	move.w	$14(a6),d0
	move.w	d0,$dff096
	clr.b	$1b(a6)

	move.l	$4(a6),(a5)
	move.w	$8(a6),$4(a5)
	move.w	$10(a6),d0
	and.w	#$fff,d0
	move.w	d0,$6(a5)
	move.w	$14(a6),d0
	or.w	d0,mt_dmacon
	bra	mt_checkcom2

mt_setdma:
	move.w	#$12c,d0
mt_wait:dbf	d0,mt_wait
	move.w	mt_dmacon,d0
	or.w	#$8000,d0
	move.w	d0,$dff096
	move.w	#$12c,d0
mt_wai2:dbf	d0,mt_wai2
	lea	$dff000,a5
	lea	mt_voice4(pc),a6
	move.l	$a(a6),$d0(a5)
	move.w	$e(a6),$d4(a5)
	lea	mt_voice3(pc),a6
	move.l	$a(a6),$c0(a5)
	move.w	$e(a6),$c4(a5)
	lea	mt_voice2(pc),a6
	move.l	$a(a6),$b0(a5)
	move.w	$e(a6),$b4(a5)
	lea	mt_voice1(pc),a6
	move.l	$a(a6),$a0(a5)
	move.w	$e(a6),$a4(a5)

	add.w	#$10,mt_pattpos
	cmp.w	#$400,mt_pattpos
	bne.s	mt_endr
mt_nex:	clr.w	mt_pattpos
	clr.b	mt_break
	addq.b	#1,mt_songpos
	and.b	#$7f,mt_songpos
	move.b	mt_songpos,d1
	cmp.b	musikdata+$3b6,d1
	bne.s	mt_endr
	move.b	musikdata+$3b7,mt_songpos
	bsr mt_init
mt_endr:tst.b	mt_break
	bne.s	mt_nex
	movem.l	(a7)+,d0-d4/a0-a3/a5-a6
	rts

mt_setmyport:
	move.w	(a6),d2
	and.w	#$fff,d2
	move.w	d2,$18(a6)
	move.w	$10(a6),d0
	clr.b	$16(a6)
	cmp.w	d0,d2
	beq.s	mt_clrport
	bge.s	mt_rt
	move.b	#$1,$16(a6)
	rts
mt_clrport:
	clr.w	$18(a6)
mt_rt:	rts

mt_myport:
	move.b	$3(a6),d0
	beq.s	mt_myslide
	move.b	d0,$17(a6)
	clr.b	$3(a6)
mt_myslide:
	tst.w	$18(a6)
	beq.s	mt_rt
	moveq	#0,d0
	move.b	$17(a6),d0
	tst.b	$16(a6)
	bne.s	mt_mysub
	add.w	d0,$10(a6)
	move.w	$18(a6),d0
	cmp.w	$10(a6),d0
	bgt.s	mt_myok
	move.w	$18(a6),$10(a6)
	clr.w	$18(a6)
mt_myok:move.w	$10(a6),$6(a5)
	rts
mt_mysub:
	sub.w	d0,$10(a6)
	move.w	$18(a6),d0
	cmp.w	$10(a6),d0
	blt.s	mt_myok
	move.w	$18(a6),$10(a6)
	clr.w	$18(a6)
	move.w	$10(a6),$6(a5)
	rts

mt_vib:	move.b	$3(a6),d0
	beq.s	mt_vi
	move.b	d0,$1a(a6)

mt_vi:	move.b	$1b(a6),d0
	lea	mt_sin(pc),a4
	lsr.w	#$2,d0
	and.w	#$1f,d0
	moveq	#0,d2
	move.b	(a4,d0.w),d2
	move.b	$1a(a6),d0
	and.w	#$f,d0
	mulu	d0,d2
	lsr.w	#$6,d2
	move.w	$10(a6),d0
	tst.b	$1b(a6)
	bmi.s	mt_vibmin
	add.w	d2,d0
	bra.s	mt_vib2
mt_vibmin:
	sub.w	d2,d0
mt_vib2:move.w	d0,$6(a5)
	move.b	$1a(a6),d0
	lsr.w	#$2,d0
	and.w	#$3c,d0
	add.b	d0,$1b(a6)
	rts

mt_nop:	move.w	$10(a6),$6(a5)
	rts

mt_checkcom:
	move.w	$2(a6),d0
	and.w	#$fff,d0
	beq.s	mt_nop
	move.b	$2(a6),d0
	and.b	#$f,d0
	tst.b	d0
	beq	mt_arpeggio
	cmp.b	#$1,d0
	beq.s	mt_portup
	cmp.b	#$2,d0
	beq	mt_portdown
	cmp.b	#$3,d0
	beq	mt_myport
	cmp.b	#$4,d0
	beq	mt_vib
	move.w	$10(a6),$6(a5)
	cmp.b	#$a,d0
	beq.s	mt_volslide
	rts

mt_volslide:
	moveq	#0,d0
	move.b	$3(a6),d0
	lsr.b	#4,d0
	tst.b	d0
	beq.s	mt_voldown
	add.w	d0,$12(a6)
	cmp.w	#$40,$12(a6)
	bmi.s	mt_vol2
	move.w	#$40,$12(a6)
mt_vol2:move.w	$12(a6),$8(a5)
	rts

mt_voldown:
	moveq	#0,d0
	move.b	$3(a6),d0
	and.b	#$f,d0
	sub.w	d0,$12(a6)
	bpl.s	mt_vol3
	clr.w	$12(a6)
mt_vol3:move.w	$12(a6),$8(a5)
	rts

mt_portup:
	moveq	#0,d0
	move.b	$3(a6),d0
	sub.w	d0,$10(a6)
	move.w	$10(a6),d0
	and.w	#$fff,d0
	cmp.w	#$71,d0
	bpl.s	mt_por2
	and.w	#$f000,$10(a6)
	or.w	#$71,$10(a6)
mt_por2:move.w	$10(a6),d0
	and.w	#$fff,d0
	move.w	d0,$6(a5)
	rts

mt_portdown:
	clr.w	d0
	move.b	$3(a6),d0
	add.w	d0,$10(a6)
	move.w	$10(a6),d0
	and.w	#$fff,d0
	cmp.w	#$358,d0
	bmi.s	mt_por3
	and.w	#$f000,$10(a6)
	or.w	#$358,$10(a6)
mt_por3:move.w	$10(a6),d0
	and.w	#$fff,d0
	move.w	d0,$6(a5)
	rts

mt_checkcom2:
	move.b	$2(a6),d0
	and.b	#$f,d0
	cmp.b	#$e,d0
	beq.s	mt_setfilt
	cmp.b	#$d,d0
	beq.s	mt_pattbreak
	cmp.b	#$b,d0
	beq.s	mt_posjmp
	cmp.b	#$c,d0
	beq.s	mt_setvol
	cmp.b	#$f,d0
	beq.s	mt_setspeed
	rts

mt_setfilt:
	move.b	$3(a6),d0
	and.b	#$1,d0
	asl.b	#$1,d0
	and.b	#$fd,$bfe001
	or.b	d0,$bfe001
	rts
mt_pattbreak:
	not.b	mt_break
	rts
mt_posjmp:
	move.b	$3(a6),d0
	subq.b	#$1,d0
	move.b	d0,mt_songpos
	not.b	mt_break
	rts
mt_setvol:
	cmp.b	#$40,$3(a6)
	ble.s	mt_vol4
	move.b	#$40,$3(a6)
mt_vol4:move.b	$3(a6),$8(a5)
	rts
mt_setspeed:
	cmp.b	#$1f,$3(a6)
	ble.s	mt_sets
	move.b	#$1f,$3(a6)
mt_sets:move.b	$3(a6),d0
	beq.s	mt_rts2
	move.b	d0,mt_speed
	clr.b	mt_counter
mt_rts2:rts

mt_sin:
	dc.b $00,$18,$31,$4a,$61,$78,$8d,$a1,$b4,$c5,$d4,$e0,$eb,$f4,$fa,$fd
	dc.b $ff,$fd,$fa,$f4,$eb,$e0,$d4,$c5,$b4,$a1,$8d,$78,$61,$4a,$31,$18

mt_periods:
	dc.w $0358,$0328,$02fa,$02d0,$02a6,$0280,$025c,$023a,$021a,$01fc,$01e0
	dc.w $01c5,$01ac,$0194,$017d,$0168,$0153,$0140,$012e,$011d,$010d,$00fe
	dc.w $00f0,$00e2,$00d6,$00ca,$00be,$00b4,$00aa,$00a0,$0097,$008f,$0087
	dc.w $007f,$0078,$0071,$0000,$0000

mt_speed:	dc.b	$6
mt_songpos:	dc.b	$0
mt_pattpos:	dc.w	$0
mt_counter:	dc.b	$0

mt_break:	dc.b	$0
mt_dmacon:	dc.w	$0
mt_samplestarts:dcb.l	$1f,0
mt_voice1:	dcb.w	10,0
		dc.w	$1
		dcb.w	3,0
mt_voice2:	dcb.w	10,0
		dc.w	$2
		dcb.w	3,0
mt_voice3:	dcb.w	10,0
		dc.w	$4
		dcb.w	3,0
mt_voice4:	dcb.w	10,0
		dc.w	$8
		dcb.w	3,0
		
		
	* Datenbereich
	* library & pointer
	
gfxname:	dc.b 'graphics.library',0
		cnop 0,2
_GfxBase:	dc.l 0


	* text
	
message:	dc.b 'THIS GREAT SCROLL TEXT WAS '
		dc.b 'CODED BY CHRIS ON AN A500 FOR THE '
		dc.b '"PROWO" AT THE NCG !  I USED THE '
		dc.b 'GREAT GRAPHIC CHIPS '
		dc.b '"COPPER" AND "BLITTER" TO '
		dc.b 'DO THE SCROLLING AND THE DISPLAY '
		dc.b 'GREETINGS TO ALL PROGRAMMERS '
		dc.b 'ON THE WORLD AND RICHY, HENNING, '
		dc.b 'SEBASTIAN AND LAST BUT NOT LEAST MARKUS !'
		dc.b '            ',0
		cnop 0,2

textptr:	dc.l 0
textcount:	dc.w 32


	* Interrupt structur
	
intstruct:	dc.l 0
		dc.l 0
		dc.b NT_INTERRUPT
		dc.b 0
		dc.l 0
		
		dc.l 0
		dc.l 0
		

	* Copperliste

		SECTION Planes,DATA_C
		
		
	* pointer auf playfields resetten
		
copperlist:	dc.w BPL1PTH
p1h:		dc.w 0
		dc.w BPL1PTL
p1l:		dc.w 0
		dc.w BPL2PTH
p2h:		dc.w 0
		dc.w BPL2PTL
p2l:		dc.w 0
		dc.w BPL3PTH
p3h:		dc.w 0
		dc.w BPL3PTL
p3l:		dc.w 0
		dc.w BPL4PTH
p4h:		dc.w 0
		dc.w BPL4PTL
p4l:		dc.w 0
		
		
	* farben fr Lady
	
		dc.w $0180,$0000,$0182,$0fff
		dc.w $0184,$0111,$0186,$0222
		dc.w $0188,$0333,$018a,$0444
		dc.w $018c,$0555,$018e,$0666
		dc.w $0190,$0777,$0192,$0888 
		dc.w $0194,$0999,$0196,$0aaa
		dc.w $0198,$0bbb,$019a,$0ccc
		dc.w $019c,$0ddd,$019e,$0eee
		
		
	* farben fr font
	
		CWAIT 0,245
		
		dc.w $0180,$0000,$0182,$0fff
		dc.w $0184,$0fec,$0186,$0ed9
		dc.w $0188,$0ec7,$018a,$0eb5
		dc.w $018c,$0da2,$018e,$0d90
		dc.w $0190,$0c80,$0192,$0b70
		dc.w $0194,$0a60,$0196,$0950
		dc.w $0198,$0840,$019a,$0730
		dc.w $019c,$0620,$019e,$0510		


	* ende copperlist

		dc.w $ffff,$fffe
		
		
	* bild
	
		incdir "ASOURCE:Demos/data/"
fontdata:	incbin "Font\320*193.raw"
picture:	incbin "Lady\352*290.raw"
		incdir "ST-00:"
musikdata:	incbin "MOD.LambadaMIDI"
ende:
