/*
** Praktische Aufgabe 3 --- Lsung von linearen Gleichungssystemen
** Coded by Christian Buth
** 24.06.2000
**
** Version 1.00: 24.06.2000 (Gauelimination implementiert)
** Version 1.10: 02.07.2000 (Householderverfahren implementiert)
*/


/*
** Includes
*/

#include <math>
#include <stdlib>
#include <string>
#include <fstream>
#include <iostream>
#include <iomanip>


/*
** Konstanten
*/

const int n1=5,n2=10,n3=50;


/*
** Prototypen
*/

void Loese_Gleichungssystem(const char *,void (*)(int),void (*)(int));
void Rueckwaerts_Einsetzen(int);
void Gauss_Elimination(int);
void Householder(int);
void Gleichungssystem_1(int);
void Gleichungssystem_2(int);
void Gleichungssystem_3(int);
double Fehler(int);
double Residuum(int);


/*
** Inline
*/

inline double sqr(double x)
  {
    return(x*x);
  }


/*
** Globale Variablen
*/

static double a[n3+1][n3+1],b[n3+1],x[n3+1],xt[n3+1];



/*
** main
*/

int main()
  {
    /* Begrungstext */
    cout << "Lineare Gleichungssysteme von Christian Buth\n"
            "(c) 2000 Christian Buth\n\n";

    /* Gleichungssysteme durch Gauelimination lsen */
    cout << "Gau Elimination:\n";
    Loese_Gleichungssystem("Gleichungssystem 1: ",Gleichungssystem_1,
                           Gauss_Elimination);
    Loese_Gleichungssystem("Gleichungssystem 2: ",Gleichungssystem_2,
                           Gauss_Elimination);
    Loese_Gleichungssystem("Gleichungssystem 3: ",Gleichungssystem_3,
                           Gauss_Elimination);

    /* Gleichungssysteme mit dem Householderverfahren lsen */
    cout << "\nHouseholder Verfahren:\n";
    Loese_Gleichungssystem("Gleichungssystem 1: ",Gleichungssystem_1,
                           Householder);
    Loese_Gleichungssystem("Gleichungssystem 2: ",Gleichungssystem_2,
                           Householder);
    Loese_Gleichungssystem("Gleichungssystem 3: ",Gleichungssystem_3,
                           Householder);
    return(EXIT_SUCCESS);
  }


/*
** Aufruffunktionen
*/

void Loese_Gleichungssystem(const char *str,void (*Gleichungssystem)(int),
                            void (*Loeser)(int))
  {
    register int i,l=strlen(str);

    (*Gleichungssystem)(n1);
    (*Loeser)(n1);
    Rueckwaerts_Einsetzen(n1);
    cout << setiosflags(ios::scientific) << setprecision(2);
    cout << str << "n = " << setw(2) << n1 << "    Fehler = " << Fehler(n1)
         << "    Residuum = " << Residuum(n1) << endl;

    (*Gleichungssystem)(n2);
    (*Loeser)(n2);
    Rueckwaerts_Einsetzen(n2);
    for (i=0; i < l; i++)
        cout << ' ';
    cout << "n = " << n2 << "    Fehler = "  << Fehler(n2)
         << "    Residuum = " << Residuum(n2) << endl;

    (*Gleichungssystem)(n3);
    (*Loeser)(n3);
    Rueckwaerts_Einsetzen(n3);
    for (i=0; i < l; i++)
        cout << ' ';
    cout << "n = " << n3 << "    Fehler = "  << Fehler(n3)
         << "    Residuum = " << Residuum(n3) << endl;
    return;
  }


/*
** Lsung von linearen Gleichungssystemen
*/

void Rueckwaerts_Einsetzen(int n)
  {
    register int i,j;
    double s;

    for (i=n; i>=1; i--)
      {
        s = 0;
        for (j=i+1; j<=n; j++)
            s += a[i][j] * xt[j];
        xt[i] = (b[i] - s) / a[i][i];
      }
    return;
  }

void Gauss_Elimination(int n)
  {
    register int i,j,k;
    double f;

    for (i=1; i<n; i++)
      {
        for (j=i+1; j<=n; j++)
          {
            f = a[j][i] / a[i][i];
            for (k=i+1; k<=n; k++)
                a[j][k] -= f * a[i][k];
            b[j] -= f * b[i];
          }
      }
    return;
  }

void Householder(int n)
  {
    register int i,j,k;
    double norm,xi,beta,s;

    /* Householder */
    for (i=1; i<n; i++)
      {
        for (j=i, norm=0; j<=n; j++)
            norm += sqr(a[j][i]);
        if (! norm)
          {
            cerr << "Fehler: Norm == 0!\n";
            exit(EXIT_FAILURE);
          }

        xi = sqrt(norm);
        if (a[i][i] > 0)
            xi = -xi;
        beta = 1 / (norm - a[i][i] * xi);
        a[i][i] -= xi;

        for (j=i+1; j<=n; j++)                                   /* P(i) A(i) */
          {
            s = 0;
            for (k=i; k<=n; k++)                                     /* <u,a> */
                s += a[k][i] * a[k][j];
            s *= beta;
            for (k=i; k<=n; k++)                        /* a - beta * <u,a> u */
                a[k][j] -= s * a[k][i];
          }

        s = 0;                                                      /* P(i) b */
        for (k=i; k<=n; k++)                                         /* <u,b> */
            s += b[k] * a[k][i];
        s *= beta;
        for (k=i; k<=n; k++)                            /* b - beta * <u,b> u */
            b[k] -= s * a[k][i];
        a[i][i] = xi;                                   /* A wiederherstellen */
      }
    return;
  }


/*
** Fehlerfunktionen
*/

double Fehler(int n)
  {
    register int i;
    double f=0;

    for (i=1; i<=n; i++)
        f += sqr(x[i] - xt[i]);
    return(sqrt(f));
  }

double Residuum(int n)
  {
    register int i,j;
    double r=0,Ax;

    for (i=1; i<=n; i++)
      {
        Ax = 0;
        for (j=i; j<=n; j++)
            Ax += a[i][j] * xt[j];
        r += sqr(b[i] - Ax);
      }
    return(sqrt(r));
  }


/*
** Matrizen erzeugen
*/

void Gleichungssystem_1(int n)
  {
    register int i,j;

    for (i=1; i<=n; i++)
      {
        for (j=1; j<=n; j++)
          {
            if (i==j)
                a[i][j] = 2;
            else if (abs(i-j) == 1)
                a[i][j] = -1;
            else
                a[i][j] = 0;
          }
        b[i] = 0;
        x[i] = i;
      }
    b[n] = n + 1;
    return;
  }

void Gleichungssystem_2(int n)
  {
    register int i,j;

    for (i=1; i<=n; i++)
      {
        for (j=1; j<=n; j++)
          {
            if (i==j || j==n)
                a[i][j] = 0.6;
            else if (i>j)
                a[i][j] = -0.6;
            else
                a[i][j] = 0;
          }
        b[i] = 0.9;
        x[i] = 0;
      }
    x[n] = 1.5;
    return;
  }

void Gleichungssystem_3(int n)
  {
    register int i,j;

    for (i=1; i<=n; i++)
      {
        b[i] = 0;
        for (j=1; j<=n; j++)
          {
            a[i][j] = 1.0 / (i+j-1);
            b[i] += 1.0 / (i+j-1);
          }
        x[i] = 1;
      }
    return;
  }
