/*
** Auswertungsprogramm Versuch 251: Statistik
** Coded by Chris
** 22.01.1998
*/


/*
** Includes
*/

#include <cmath>
#include <iostream>
#include <iomanip>


/*
** Defines
*/

#define sqr(a) ((a)*(a))


/*
** Constants
*/

const int maxValue = 200;


/*
** Prototypes
*/

void statistics(int *,bool);
int fak(int);


/*
** Mewerte
*/

/* Mewerte Aufgabe 2 */

int data1[] =
  {
    93,113,88,99,107,80,103,103,112,100,99,96,90,94,98,81,105,107,92,96,87,104,
    94,115,92,86,110,107,118,86,90,113,112,103,95,90,110,92,104,97,92,109,83,
    107,96,96,111,94,87,105,90,90,91,104,104,76,86,105,90,100,95,89,98,112,117,
    90,99,83,107,78,102,97,95,99,96,121,97,110,104,109,98,104,112,103,107,90,99,
    105,84,104,97,91,103,98,94,98,107,86,81,87,96,79,98,113,93,97,92,97,118,109,
    99,98,88,121,99,109,114,85,96,94,88,113,110,119,110,86,89,90,99,108,101,116,
    108,106,97,110,86,107,92,99,136,99,105,86,113,93,78,107,102,105,91,95,116,
    91,107,100,102,93,101,109,101,90,92,89,95,105,99,96,126,92,95,122,90,94,96,
    97,85,100,98,92,98,110,88,83,124,94,95,82,98,96,99,102,105,99,122,91,84,102,
    106,105,
    -1         					      /* Termination of table */
  };


/* Mewerte Aufgabe 3 */

int data2[] =
  {
    3,1,3,3,7,4,4,5,6,4,4,2,7,2,3,3,3,4,5,4,3,4,2,5,7,3,5,3,5,4,3,1,3,2,7,2,4,8,
    3,2,5,3,7,4,4,4,6,5,1,3,3,1,5,2,2,7,4,4,3,6,5,4,5,5,3,2,3,6,1,2,4,6,3,3,5,3,
    6,2,1,2,3,6,1,2,6,5,1,2,2,5,5,9,5,3,1,4,2,6,0,7,
    -1         					      /* Termination of table */
  };


/* Histogrammdaten (Quick and dirty!) */

int histogram[maxValue];      /* Alle Werte mssen kleiner als maxValue sein! */


/*
** main
*/

int main()
  {
    cout << "V251: Statistik\n\n";
    cout << "Aufgabe 2:\n";
    statistics(data1,false);
    cout << "\n\nAufgabe 3:\n";
    statistics(data2,true);
    return(0);
  }


/*
** Ein Ensemble auswerten
*/

void statistics(int *data,bool poisson)
  {
    int i,
        NoMWBiggerSigma  = 0,
        NoMWBigger2Sigma = 0,
        NoMWBigger3Sigma = 0,
        NoMWBigger4Sigma = 0;
    double nave = 0,
           deviq = 0,
           devi,
           f;
    for (i = 0; data[i] != -1; i++)
        nave += data[i];
    nave /= i;
    cout << "Number values  : " << i << "\n"
         << "average n      : " << nave << "\n";
    nave = floor(nave);
    cout << "Floor average n: " << nave << "\n";
    for (i = 0; data[i] != -1; i++)
        deviq += sqr(data[i] - nave);
    deviq /= i;
    devi = sqrt(deviq);
    cout << "deviation^2    : " << deviq << endl
         << "deviation      : " << devi << endl << endl;

    for (i = 0; data[i] != -1; i++)
      {
        f = fabs(data[i] - nave);
        if (f > devi)
            NoMWBiggerSigma++;
        if (f > 2 * devi)
            NoMWBigger2Sigma++;
        if (f > 3 * devi)
            NoMWBigger3Sigma++;
        if (f > 4 * devi)
            NoMWBigger4Sigma++;
      }
    cout << "|n_i - n_ave| > sigma   : " << NoMWBiggerSigma
         << '\t' << double(NoMWBiggerSigma)  / i * 100 << "%\n";
    cout << "|n_i - n_ave| > 2*sigma : " << NoMWBigger2Sigma
         << '\t' << double(NoMWBigger2Sigma) / i * 100 << "%\n";
    cout << "|n_i - n_ave| > 3*sigma : " << NoMWBigger3Sigma
         << '\t' << double(NoMWBigger3Sigma) / i * 100 << "%\n";
    cout << "|n_i - n_ave| > 4*sigma : " << NoMWBigger4Sigma
         << '\t' << double(NoMWBigger4Sigma) / i * 100 << "%\n";


    cout << "\nHistogramm:\n";
    for (i = 0; i < maxValue; i++)
        histogram[i] = 0;
    for (i = 0; data[i] != -1; i++)
        histogram[data[i]]++;
    for (i = 0; i < maxValue; i++)
      {
        if (histogram[i])
            cout << i << ": " << histogram[i] << '\t';
      }
    cout << endl;


    if (! poisson)
        return;
    cout << "\nWahrscheinlichkeiten * 100:\n";
    for (i = 0; i < maxValue; i++)
      {
        if (histogram[i])
            cout << i << ": " << pow(nave,i) * exp(-nave) / fak(i) * 100 <<'\t';
      }
    cout << endl;
    return;
  }


/*
** Fakultt berechnen
*/

int fak(int n)
  {
    int i,f = 1;
    for (i = 1; i <= n; i++)
        f *= i;
    return(f);
  }
